import java.rmi.server.*;
import java.rmi.*;

public class Connection_controller extends UnicastRemoteObject implements Connection_controller_interface
{
	private Server server;
	private File_handler fh;
	private Orders order;
	
	/**
	 * Constructor
	 **/
	
	public Connection_controller(Server server) throws RemoteException
	{
		this.server = server;
		fh = new File_handler();
		order = new Orders();
	}
	
	/**
	 * For starting a game
	 * @param numberOfPlayers - How many players are playing this game
	 * @param playerNicks - Nicknames for all players
	 * @param playerPW - PassWords for all players
	 **/
	
	public void startGame(int numberOfPlayers, String [] playerNicks, String [] playerPW) throws RemoteException
	{
		fh.startGame(0, numberOfPlayers, playerNicks, playerPW);
	}
	
	/**
	 * NOT FINISHED - Not sure if this should only be temp or not
	 * At present time it only loads the game to show if it works
	 **/
	
	public void loadGame(int gameNumber) throws RemoteException
	{
		fh.loadGame(gameNumber);
	}
	
	/**
	 * Returns selected Player Index, if username and Password are correct
	 * @param gameNumber - What game is this player playing
	 * @param playerNick - Nickname of player
	 * @param playerPW - PassWord for player
	 * @return Player index, used on Server (-1 if login failed)
	 **/
	
	public int getPlayerIndex(int gameNumber, String playerNick, String playerPW) throws RemoteException
	{		
		return fh.login(gameNumber, playerNick, playerPW);
	}
	
	/**
	 * To issue an order
	 **/
	
	public void issueOrder(int gameNumber, String playerNick, String playerPW, int orderIndex, int targetPlayerIndex, int targetCityIndex) throws RemoteException
	{
		int playerIndex = getPlayerIndex(gameNumber, playerNick, playerPW);
		
		order.issueOrder(gameNumber, playerIndex, orderIndex, targetPlayerIndex, targetCityIndex);
	}
}